package gov.va.med.mhv.usermgmt.util;

import gov.va.med.mhv.usermgmt.enumeration.ExtractEnablementStatus;

/**
 * Util class for handling ExtractEnablementStatus. 
 * 
 * This version of the class is from the User Management Service
 * and will not likely be in-synch with changes applied to it.
 * If there is a problem with the use of the class, replace this
 * class with the most current version in User Management Service
 * Utils.
 * 
 * 
 * @author Robert Paul (Aquilent Inc.)
 *
 */
public final class ExtractEnablementStatusUtils {

	public static final ExtractEnablementStatus DISABLED = 
		ExtractEnablementStatus.getEnum(ExtractEnablementStatus.DISABLED);
	
	public static final ExtractEnablementStatus ENABLED = 
		ExtractEnablementStatus.getEnum(ExtractEnablementStatus.ENABLED);
	
	public static final ExtractEnablementStatus PARTIAL = 
		ExtractEnablementStatus.getEnum(ExtractEnablementStatus.PARTIAL);
	
	/**
	 * Util method to convert a String representation of the enumeration to an 
	 * ExtractEnablementStatus enumeration. Note if this cannot be determined then 
	 * a DISABLED enumeration is returned.
	 * @param value
	 * @return
	 */
	public static final ExtractEnablementStatus getEnablementEnumeration(String value)
	{
		ExtractEnablementStatus e = ExtractEnablementStatus.
		getEnum(value);
		if(e == null){
			return ExtractEnablementStatus.
				getEnum(ExtractEnablementStatus.DISABLED);
		}
		return e;
	}
	
	/**
	 * Central logic to determine if the extract is enabled. Note
	 * the assumption is enabled or partial translate into enablement
	 * of true, at least to the UI. 
	 * @param status
	 * @return
	 */
	public static final boolean isExtractViewEnabled(ExtractEnablementStatus status)
	{
		boolean enabled = false;
		if(status == ENABLED || status == PARTIAL){
			enabled = true;
		}
		return enabled;
	}
	
	private ExtractEnablementStatusUtils(){
		//Hide the constructor so that it cannot be instantiated
	}
}
